<!DOCTYPE html>
<html lang="<?php echo $_LANG['lang_html']; ?>" data-bs-theme="<?php echo $setting->theme_mode_site; ?>">

<head itemtype="https://schema.org/WebSite">
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title><?php echo $page_title; ?></title>
    <meta name="description" content="<?php echo $page_description; ?>">

    <link rel="icon" href="<?php echo PATH_SYSTEM; ?>public/<?php echo $setting->favicon_site; ?>">

    <meta property="og:type" content="website">
    <meta property="og:title" content="<?php echo $og_title; ?>">
    <meta property="og:description" content="<?php echo $og_description; ?>">
    <meta property="og:image:width" content="<?php echo $og_image_width; ?>">
    <meta property="og:image:height" content="<?php echo $og_image_height; ?>">
    <meta property="og:image" content="<?php echo $og_image; ?>">
    <meta property="og:url" content="<?php echo $og_url; ?>">
    <link rel="canonical" href="<?php echo $canonical; ?>">

    <!-- preload -->
    <link rel="preconnect" href="https://www.googletagmanager.com">
    <link rel="preconnect" href="https://www.youtube.com">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

    <link rel="preload" as="style" href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&display=swap">
    <link rel="preload" as="style" href="https://fonts.googleapis.com/css2?family=Oswald:wght@200..700&display=swap">
    <link rel="preload" as="style" href="<?php echo PATH_SYSTEM; ?>resources/css/bootstrap.min.css">
    <link rel="preload" as="style" href="<?php echo PATH_SYSTEM; ?>resources/css/main.css?v=<?php echo $setting->version; ?>">
    <link rel="preload" as="style" href="<?php echo PATH_SYSTEM . PATH_VIEW; ?>/custom.css?v=<?php echo $setting->version; ?>">
    <!-- preload end -->

    <!-- css custom -->
    <?php
    if (!empty($stylesheet)) {
        foreach ($stylesheet as $style) {
            echo '<link rel="preload" as="style"  href="' . $style . '?v=' . $setting->version . '">';
            echo '<link rel="stylesheet" href="' . $style . '?v=' . $setting->version . '">';
        }
    }
    ?>

    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&display=swap">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Oswald:wght@200..700&display=swap">
    <link rel="stylesheet" href="<?php echo PATH_SYSTEM; ?>resources/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo PATH_SYSTEM; ?>resources/css/main.css?v=<?php echo $setting->version; ?>">
    <link rel="stylesheet" href="<?php echo PATH_SYSTEM . PATH_VIEW; ?>/custom.css?v=<?php echo $setting->version; ?>">

    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "WebSite",
            "name": "<?php echo $setting->title_site; ?>",
            "url": "<?php echo BASE_URL; ?>"
        }
    </script>

    <?php

    //bg
    $background_type = !empty($theme_global->background) ? $theme_global->background : '';
    $background_color = !empty($theme_global->background_color) && $background_type != '' ? $theme_global->background_color : '#795548';
    $background_image = '';


    if ($background_type === 'image') {
        $background_image = !empty($theme_global->background_image) ? "url(" . PATH_SYSTEM . "public/{$theme_global->background_image}) center center / cover no-repeat fixed" : '';
    }

    //text
    $text_secondary = !empty($theme_custom->text_secondary) ? $theme_custom->text_secondary : '#00b9fd';

    ?>
    <style>
        [data-bs-theme='dark'] {
            --bs-dark-bg-subtle: <?php echo $text_secondary; ?>;
            --bs-form-control-bg: #171717;
            --bs-border-color: #202020;
            --bs-secondary-color: #b5b5b5;
            --bs-dark-text: #b5b5b5;
            --bs-body-bg: #191919;
            --bs-heading-color: #fff;
            --bs-body-color: #fff;
            --bs-emphasis-color: #000;

            .list-group-item-action:focus,
            .list-group-item-action:hover {
                color: #fff;
            }

            .events .divider {
                color: var(--bs-dark-bg-subtle);
            }

            /* Custom */
            --bg-primary: <?php echo $background_color; ?>;
            --bg-secondary: rgba(7 10 12 / <?php echo $background_type === 'image' ? '.9' : '1'; ?>);
            --text-primary: #fff;

            --text-secondary: #8a8a8a;
            --bg-footer: rgba(14 14 14 / <?php echo $background_type === 'image' ? '.9' : '1'; ?>);
            --bg-footer-info: rgba(14 14 14 / <?php echo $background_type === 'image' ? '.95' : '1'; ?>);

            .btn-close {
                filter: var(--bs-btn-close-white-filter);
            }

        }

        [data-bs-theme='light'] {
            --bs-dark-bg-subtle: <?php echo $text_secondary; ?>;
            --bs-form-control-bg: #fff;
            --bs-border-color: #8a8a8a;
            --bs-secondary-color: #4a4a4a;
            --bs-dark-text: #4a4a4a;
            --bs-body-bg: rgba(255, 255, 255, .5);
            --bs-heading-color: #000;
            --bs-body-color: #000;
            --bs-emphasis-color: #fff;

            .list-group-item-action:focus,
            .list-group-item-action:hover {
                color: #000;
            }

            .app-card,
            .app-card span {
                color: #fff;
            }

            .dropdown-menu,
            header .offcanvas.show {
                background: #fff !important;
            }

            .events .divider {
                color: var(--bs-dark-bg-subtle);
            }

            /* Custom */
            --bg-primary: <?php echo $background_color; ?>;
            --bg-secondary: rgba(255 255 255 / .7);
            --text-primary: #000;
            --text-secondary: #8a8a8a;
            --bg-footer: rgba(255 255 255 / .8);
            --bg-footer-info: rgba(255 255 255 / .8);
        }

        body {
            background: <?php echo $background_image; ?>;
            background-color: var(--bg-primary);
        }

        .bg-body-tertiary {
            background: var(--bg-secondary) !important;
        }

        .dropdown-menu,
        header .offcanvas {
            background: var(--bg-secondary) !important;
        }

        .navbar a,
        .navbar .navbar-toggler {
            color: var(--text-primary);
        }

        .navbar a:hover {
            color: var(--text-secondary) !important;
            background: none;
        }

        .navbar .active {
            color: var(--bs-dark-bg-subtle) !important;
            background: none;
        }

        .text-muted,
        .card-subtitle,
        .datatime {
            color: var(--text-secondary) !important;
        }

        footer #footer {
            background: var(--bg-footer) !important;
        }

        footer #footer-info {
            background: var(--bg-footer-info) !important;
        }

        .page-link {
            color: var(--text-primary);
            background: var(--bg-secondary);
        }

        .modal .modal-content {
            background: var(--bs-emphasis-color);
        }

        .pagination {
            --bs-pagination-disabled-color: var(--text-primary);
        }
    </style>

</head>

<body itemscope itemtype="https://schema.org/WebPage">
