<?php include PATH_VIEW . '/layout/header.tpl'; ?>

<div id="ajaxArea">
	<div class="container bg-body-tertiary p-3">

		<div class="row">

			<div class="col-md-8">
				<section id="column1" class="mb-4 events">
					<h1 class="title-page"><?php echo $header_title; ?></h1>
					<section id="breadcrumb" class="border-bottom mb-4">
						<?php include PATH_VIEW . '/layout/breadcrumb.tpl' ?>
					</section>
					<?php if ($itemListToday) { ?>
						<div class="mb-4">
							<h2><?php echo $_LANG['today']; ?></h2>
							<div class="row">
								<?php foreach ($itemListToday as $item) { ?>
									<div class="col-lg-4 col-md-6 col-sm-6 col-6">
										<article class="card article-card">
											<a class="link-article" href="<?php echo PATH_SYSTEM . "events/view/" . $item->postId . '-' . $item->postUrl; ?>" aria-label="<?php echo $item->title; ?>"></a>
											<div class="article-img">
												<img loading="lazy" src="<?php echo PATH_SYSTEM . "public/event/" . $item->thumbnail; ?>" class="img-fluid rounded-start" alt="<?php echo $item->title; ?>">
											</div>
											<div class="card-body">
												<span class="datatime">
													<?php
													$dateStart = FormatDate('D,d,F', $item->date_start);
													$dateEnd = FormatDate('D,d,F', $item->date_end);
													$timeStart = FormatDate($setting->format_time, $item->date_start);
													$timeEnd = FormatDate($setting->format_time, $item->date_end);

													if ($dateStart == $dateEnd) {
														$dateStart = explode(',', $dateStart);
														echo $_LANG[$dateStart[0] . '_short'] . ', ' . $dateStart[1] . ' ' . $_LANG[$dateStart[2] . '_short'] . ' · ' . $timeStart;
													} else {
														$dateEnd = explode(',', $dateEnd);
														$dateStart = explode(',', $dateStart);
														echo $dateStart[1] . ' ' . $_LANG[$dateStart[2] . '_short'] . '<span class="divider"> <i class="fas fa-angle-right"></i> </span>' . $dateEnd[1] . ' ' . $_LANG[$dateEnd[2] . '_short'];
													}
													?>
												</span>
												<h3 class="card-title"><?php echo $item->title; ?></h3>
												<span class="location card-text"><?php echo $item->location; ?></span>
											</div>

											<?php if ($item->date_start <= $dateTimeCurrent && $item->date_end >= $dateTimeCurrent) { ?>
												<span class="label"><label class="badge text-bg-success"><?php echo $_LANG['now']; ?></label></span>
											<?php } elseif ($item->date_end < $dateTimeCurrent) { ?>
												<span class="label"><label class="badge text-bg-danger"><?php echo $_LANG['expired']; ?></label></span>
											<?php } else { ?>
												<span class="label"><label class="badge text-bg-primary"><?php echo $_LANG['today']; ?></label></span>
											<?php } ?>

										</article>
									</div>
								<?php } ?>
							</div>
						</div>
					<?php } ?>

					<?php if ($itemListNext) { ?>
						<div class="mb-3">
							<h2><?php echo $_LANG['upcoming']; ?></h2>
							<div class="row">
								<?php foreach ($itemListNext as $item) { ?>
									<div class="col-lg-4 col-md-6 col-sm-6 col-6">
										<article class="card article-card">
											<a class="link-article" href="<?php echo PATH_SYSTEM . "events/view/" . $item->postId . '-' . $item->postUrl; ?>" aria-label="<?php echo $item->title; ?>"></a>
											<div class="article-img">
												<img loading="lazy" src="<?php echo PATH_SYSTEM . "public/event/" . $item->thumbnail; ?>" class="img-fluid rounded-start" alt="<?php echo $item->title; ?>">
											</div>
											<div class="card-body">
												<span class="datatime">
													<?php
													$dateStart = FormatDate('D,d,F', $item->date_start);
													$dateEnd = FormatDate('D,d,F', $item->date_end);
													$timeStart = FormatDate($setting->format_time, $item->date_start);

													if ($dateStart == $dateEnd) {
														$dateStart = explode(',', $dateStart);
														echo $_LANG[$dateStart[0] . '_short'] . ', ' . $dateStart[1] . ' ' . $_LANG[$dateStart[2] . '_short'] . ' · ' . $timeStart;
													} else {
														$dateEnd = explode(',', $dateEnd);
														$dateStart = explode(',', $dateStart);
														echo $dateStart[1] . ' ' . $_LANG[$dateStart[2] . '_short'] . '<span class="divider"> <i class="fas fa-angle-right"></i> </span>' . $dateEnd[1] . ' ' . $_LANG[$dateEnd[2] . '_short'];
													}
													?>
												</span>
												<h3 class="card-title"><?php echo $item->title; ?></h3>
												<span class="location card-text"><?php echo $item->location; ?></span>
											</div>
											<span class="label"><label class="badge text-bg-primary"><?php echo $_LANG['next']; ?></label></span>
										</article>
									</div>
								<?php } ?>
							</div>
						</div>
					<?php } ?>

					<?php if ($itemListExpired) { ?>
						<div class="mb-3">
							<h2><?php echo $_LANG['expiries']; ?></h2>
							<div class="row">
								<?php foreach ($itemListExpired as $item) { ?>
									<div class="col-lg-4 col-md-6 col-sm-6 col-6">
										<article class="card article-card">
											<a class="link-article" href="<?php echo PATH_SYSTEM . "events/view/" . $item->postId . '-' . $item->postUrl; ?>" aria-label="<?php echo $item->title; ?>"></a>
											<div class="article-img">
												<img loading="lazy" src="<?php echo PATH_SYSTEM . "public/event/" . $item->thumbnail; ?>" class="img-fluid rounded-start" alt="<?php echo $item->title; ?>">
											</div>
											<div class="card-body">
												<span class="datatime">
													<?php
													$dateStart = FormatDate('D,d,F', $item->date_start);
													$dateEnd = FormatDate('D,d,F', $item->date_end);
													$timeStart = FormatDate($setting->format_time, $item->date_start);

													if ($dateStart == $dateEnd) {
														$dateStart = explode(',', $dateStart);
														echo $_LANG[$dateStart[0] . '_short'] . ', ' . $dateStart[1] . ' ' . $_LANG[$dateStart[2] . '_short'] . ' · ' . $timeStart;
													} else {
														$dateEnd = explode(',', $dateEnd);
														$dateStart = explode(',', $dateStart);
														echo $dateStart[1] . ' ' . $_LANG[$dateStart[2] . '_short'] . '<span class="divider"> <i class="fas fa-angle-right"></i> </span>' . $dateEnd[1] . ' ' . $_LANG[$dateEnd[2] . '_short'];
													}
													?>
												</span>
												<h3 class="card-title"><?php echo $item->title; ?></h3>
												<span class="location card-text"><?php echo $item->location; ?></span>
											</div>
											<span class="label"><label class="badge text-bg-danger"><?php echo $_LANG['expired']; ?></label></span>
										</article>
									</div>
								<?php } ?>
							</div>
							<?php echo pagination($pathPage, $countList, $perPage, $currentPage, $queryStringArray); ?>
						</div>
					<?php } ?>

					<?php if (!$itemListExpired && !$itemListNext && !$itemListToday) { ?>
						<div class="mb-3">
							<div class="alert alert-danger" role="alert">
								<?php echo $_LANG['empty'] ?>
							</div>
						</div>
					<?php } ?>

				</section>
			</div>

			<div class="col-md-4">
				<aside>
					<section id="column2" class="row">
						<?php
						// widgets column 2
						include PATH_VIEW . '/layout/search.tpl';
						include PATH_VIEW . '/layout/category.tpl';

						$widgetPos = 4;
						include PATH_VIEW . '/layout/widget.tpl';
						?>
					</section>
				</aside>
			</div>

		</div>

	</div>
</div>

<?php include PATH_VIEW . '/layout/footer.tpl'; ?>
