<?php include PATH_VIEW . '/layout/header.tpl'; ?>

<div id="ajaxArea">
	<div class="container bg-body-tertiary p-3">

		<div class="row">

			<div class="col-md-8">
				<section id="column1" class="mb-4">
					<h1 class="title-page"><?php echo $header_title; ?></h1>
					<section id="breadcrumb" class="border-bottom mb-4">
						<?php include PATH_VIEW . '/layout/breadcrumb.tpl' ?>
					</section>
					<?php if ($itemList) { ?>
						<?php foreach ($itemList as $item) { ?>
							<article class="card article-card">
								<a class="link-article" href="<?php echo PATH_SYSTEM . "news/view/" . $item->postId . '-' . $item->postUrl; ?>" aria-label="<?php echo $item->title; ?>"></a>
								<div class="row g-0">
									<div class="col-md-4 article-img">
										<img loading="lazy" src="<?php echo PATH_SYSTEM . "public/news/" . $item->thumbnail; ?>" class="img-fluid rounded-start" alt="<?php echo $item->title; ?>">
									</div>
									<div class="col-md-8">
										<div class="card-body d-flex flex-column">
											<h3 class="card-title"><?php echo $item->title; ?></h3>
											<p class="card-text"><?php echo $item->description; ?></p>

											<div class="card-info mt-auto">
												<span class="card-text"><small class="text-muted"><?php echo elapsedTime($item->date_post); ?></small></span>
												<a href="<?php echo PATH_SYSTEM . 'news/' . $item->categoryUrl; ?>" class="badge text-bg-secondary"><?php echo $item->categoryName; ?></a>
											</div>
										</div>
									</div>
								</div>
							</article>
						<?php } ?>
						<?php echo pagination($pathPage, $countList, $perPage, $currentPage, $queryStringArray); ?>
					<?php } else { ?>
						<div class="alert alert-danger" role="alert">
							<?php echo $_LANG['empty'] ?>
						</div>
					<?php } ?>

				</section>
			</div>

			<div class="col-md-4">
				<aside>
					<section id="column2" class="row">
						<?php
						// widgets column 2
						include PATH_VIEW . '/layout/search.tpl';
						include PATH_VIEW . '/layout/category.tpl';

						$widgetPos = 4;
						include PATH_VIEW . '/layout/widget.tpl';
						?>
					</section>
				</aside>
			</div>


		</div>

	</div>
</div>

<?php include PATH_VIEW . '/layout/footer.tpl'; ?>
