<!DOCTYPE html>
<html lang="<?php echo $_LANG['lang_html']; ?>" data-bs-theme="<?php echo $setting->theme_mode_site; ?>">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title><?php echo $page_title; ?></title>
    <meta name="description" content="<?php echo $page_description; ?>">

    <link rel="icon" href="<?php echo PATH_SYSTEM; ?>public/<?php echo $setting->favicon_site; ?>">
    <meta property="og:type" content="website">
    <meta property="og:title" content="<?php echo $og_title; ?>">
    <meta property="og:description" content="<?php echo $og_description; ?>">
    <meta property="og:image:width" content="<?php echo $og_image_width; ?>">
    <meta property="og:image:height" content="<?php echo $og_image_height; ?>">
    <meta property="og:image" content="<?php echo $og_image; ?>">
    <meta property="og:url" content="<?php echo $og_url; ?>">
    <link rel="canonical" href="<?php echo $canonical; ?>">

    <link rel="manifest" href="<?php echo PATH_SYSTEM; ?>api/manifestPwa?v=<?php echo $setting->version; ?>" />
    <!-- ios support -->
    <link rel="apple-touch-icon" href="<?php echo PATH_SYSTEM; ?>public/<?php echo $setting->favicon_site; ?>" />
    <meta name="apple-mobile-web-app-status-bar" content="#000000" />
    <meta name="theme-color" content="#000000" />

    <!-- preload -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preload" as="style" href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&display=swap">
    <!-- preload end -->

    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&display=swap">
    <link rel="stylesheet" href="<?php echo PATH_SYSTEM; ?>resources/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo PATH_SYSTEM; ?>resources/css/pwa.css?v=<?php echo $setting->version; ?>">

    <?php

    //bg
    $background_type = !empty($theme_global->background) ? $theme_global->background : '';
    $background_color = !empty($theme_global->background_color) && $background_type != '' ? $theme_global->background_color : '#fff';
    $background_image = '';

    if ($background_type === 'image') {
        $background_image = !empty($theme_global->background_image) ? "url(" . PATH_SYSTEM . "public/{$theme_global->background_image}) center center / cover no-repeat fixed" : '';
    }

    //text
    $text_secondary = !empty($theme_custom->text_secondary) ? $theme_custom->text_secondary : '#00b9fd';

    ?>

    <style>
        body {
            background: <?php echo $background_image; ?>;
            background-color: <?php echo $background_color; ?>;
        }

        [data-bs-theme='dark'] {
            .content {
                background: rgba(var(--bs-tertiary-bg-rgb), <?php echo $background_type === 'image' ? '.8' : '1'; ?>);
                height: 100vh;
            }

            --bs-dark-text: #b5b5b5;
            --bs-emphasis-color: #fff;
            --bs-body-bg: #191919;
            --bs-body-color: #fff;
            --navbar-color: #fff;

        }

        [data-bs-theme='light'] {
            .content {
                background: rgba(255 255 255 / .7);
                height: 100vh;
            }

            --bs-dark-text: #4a4a4a;
            --bs-emphasis-color: #000;
            --bs-body-bg: rgba(255, 255, 255);
            --bs-body-color: #000;
            --navbar-color: #000;
        }

        a:hover {
            color: <?php echo $text_secondary; ?> !important;
        }

        .navbar a,
        .navbar .navbar-toggler {
            color: var(--navbar-color);
        }

        .navbar a:hover {
            color: <?php echo $text_secondary; ?> !important;
            background: none;
        }
    </style>


</head>

<body>
    <audio id="player_audio" preload="none" autoplay></audio>
    <div class="container-fluid content">
        <div class="d-flex align-items-center flex-column " style="height:90vh">

            <header class="mb-auto">
                <nav class="navbar fixed-top">
                    <div class="container-fluid">
                        <a class="navbar-toggler" href="<?php echo PATH_SYSTEM; ?>" target="_blank" aria-label="website">
                            <span class="fas fa-globe"></span>
                        </a>

                        <div class="navbar-logo">
                            <img loading="lazy" src="<?php echo PATH_SYSTEM; ?>public/<?php echo $setting->logo_site; ?>" alt="logo">
                        </div>

                        <button class="navbar-toggler" type="button" id="shareBS" data-url="<?php echo $og_url; ?>" data-title="<?php echo $og_title; ?>" aria-label="Share">
                            <span class="fas fa-share"></span>
                        </button>
                    </div>
                </nav>
            </header>

            <section class="player text-center mb-4">
                <div class="player-info d-flex flex-column mb-3">
                    <img loading="lazy" class="rounded mx-auto d-block mb-3" src="<?php echo PATH_SYSTEM; ?>public/cover_default.jpg" alt="cover">
                    <div class="text-center">
                        <div class="now"><?php echo $_LANG['playing_now']; ?></div>
                        <marquee direction="left" id="playingNow">...</marquee>
                    </div>
                </div>
                <div class="player-control">
                    <button class="b-play" aria-label="<?php echo $_LANG['play_radio']; ?>" data-stream="<?php echo $stream_url; ?>"></button>
                </div>
            </section>

            <footer class="mb-auto">
                <ul class="nav nav-pills justify-content-center">

                    <?php if ($setting->link_whatsapp) { ?>
                        <li><a href="https://api.whatsapp.com/send?phone=<?php echo $setting->link_whatsapp; ?>" target="_blank" aria-label="WhatsApp"><i class="fab fa-whatsapp"></i></a></li>
                    <?php } ?>

                    <?php if ($setting->link_youtube) { ?>
                        <li><a href="<?php echo $setting->link_youtube; ?>" target="_blank" aria-label="Youtube"><i class="fab fa-youtube"></i></a></li>
                    <?php } ?>

                    <?php if ($setting->link_instagram) { ?>
                        <li><a href="<?php echo $setting->link_instagram; ?>" target="_blank" aria-label="Instagram"><i class="fab fa-instagram"></i></a></li>
                    <?php } ?>

                    <?php if ($setting->link_facebook) { ?>
                        <li><a href="<?php echo $setting->link_facebook; ?>" target="_blank" aria-label="Facebook"><i class="fab fa-facebook"></i></a></li>
                    <?php } ?>

                    <?php if ($setting->link_tiktok) { ?>
                        <li><a href="<?php echo $setting->link_tiktok; ?>" target="_blank" aria-label="TikTok"><i class="fab fa-tiktok"></i></a></li>
                    <?php } ?>

                    <?php if ($setting->link_linkedin) { ?>
                        <li><a href="<?php echo $setting->link_linkedin; ?>" target="_blank" aria-label="Linkedin"><i class="fab fa-linkedin"></i></a></li>
                    <?php } ?>

                    <?php if ($setting->link_telegram) { ?>
                        <li><a href="<?php echo $setting->link_telegram; ?>" target="_blank" aria-label="Telegram"><i class="fab fa-telegram"></i></a></li>
                    <?php } ?>

                    <?php if ($setting->link_twitter) { ?>
                        <li><a href="<?php echo $setting->link_twitter; ?>" target="_blank" aria-label="Twitter"><i class="fab fa-x-twitter"></i></a></li>
                    <?php } ?>

                    <?php if ($setting->link_pinterest) { ?>
                        <li><a href="<?php echo $setting->link_pinterest; ?>" target="_blank" aria-label="Pinterest"><i class="fab fa-pinterest"></i></a></li>
                    <?php } ?>

                    <?php if ($setting->link_discord) { ?>
                        <li><a href="<?php echo $setting->link_discord; ?>" target="_blank" aria-label="Discord"><i class="fab fa-discord"></i></a></li>
                    <?php } ?>

                    <?php if ($setting->link_spotify) { ?>
                        <li><a href="<?php echo $setting->link_spotify; ?>" target="_blank" aria-label="Spotify"><i class="fab fa-spotify"></i></a></li>
                    <?php } ?>

                    <?php if ($setting->link_soundcloud) { ?>
                        <li><a href="<?php echo $setting->link_soundcloud; ?>" target="_blank" aria-label="SoundCloud"><i class="fab fa-soundcloud"></i></a></li>
                    <?php } ?>

                </ul>

                <div class="mt-5">
                    <span id="LoadAds"></span>
                </div>

            </footer>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="installModal" tabindex="-1" aria-labelledby="installModal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered ">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="text-end">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="mb-4">
                        <div class="text-center">
                            <img class="rounded mb-4" src="<?php echo PATH_SYSTEM; ?>public/<?php echo $setting->favicon_site; ?>" alt="<?php echo $_LANG['app_web']; ?>">
                            <h1 class="mb-3 fs-5 text-uppercase"><?php echo $_LANG['app_web_install']; ?></h1>
                            <p><?php echo $_LANG['msg_install_pwa']; ?></p>
                        </div>
                        <ol>
                            <li><?php echo $_LANG['guide_pwa_one']; ?></li>
                            <li><?php echo $_LANG['guide_pwa_two']; ?></li>
                            <li><?php echo $_LANG['guide_pwa_three']; ?></li>
                        </ol>
                    </div>
                    <div class="text-center mb-3">
                        <button type="button" id="install" class="btn btn-primary"><?php echo $_LANG['install_now']; ?></button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="installModalIos" tabindex="-1" aria-labelledby="installModal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered ">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="text-end">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="mb-4">
                        <div class="text-center">
                            <img class="rounded mb-4" src="<?php echo PATH_SYSTEM; ?>public/<?php echo $setting->favicon_site; ?>" alt="<?php echo $_LANG['app_web']; ?>">
                            <h1 class="mb-3 fs-5 text-uppercase"><?php echo $_LANG['app_web_install']; ?></h1>
                            <p><?php echo $_LANG['msg_install_pwa']; ?></p>
                        </div>
                        <ol>
                            <li>
                                <?php
                                echo str_replace(
                                    '{iconShare}',
                                    '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
									<path fill="currentColor" d="M17 8h2a2 2 0 0 1 2 2v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-9a2 2 0 0 1 2-2h2v2H5v9h14v-9h-2V8zM6.5 5.5l1.414 1.414L11 3.828V14h2V3.828l3.086 3.086L17.5 5.5L12 0L6.5 5.5z" />
									</svg>',
                                    $_LANG['guide_pwa_ios_one']
                                );
                                ?>
                            </li>
                            <li><?php echo $_LANG['guide_pwa_ios_two']; ?></li>
                            <li><?php echo $_LANG['guide_pwa_three']; ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script defer src="<?php echo PATH_SYSTEM; ?>resources/js/jquery.min.js"></script>
    <script defer src="<?php echo PATH_SYSTEM; ?>resources/js/bootstrap.bundle.min.js"></script>
    <script defer src="<?php echo PATH_SYSTEM; ?>resources/js/pwa.js?v=<?php echo $setting->version; ?>"></script>

    <?php if ($setting->google_analytics) { ?>
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo $setting->google_analytics; ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];

            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());
            gtag('config', '<?php echo $setting->google_analytics; ?>', {
                'page_path': location.href.replace(location.origin, "")
            });
        </script>
    <?php } ?>
    <script>
        var CONFIG = {
            themeMode: '<?php echo $setting->theme_mode_site; ?>', // dark, light, auto
            pathSystem: '<?php echo PATH_SYSTEM; ?>'
        };
    </script>
</body>

</html>
