<?php include PATH_VIEW . '/layout/header.tpl'; ?>

<div id="ajaxArea">
    <div class="container bg-body-tertiary p-3">

        <div class="row">
            <div class="col-md-12 mb-4">
                <section id="column1" class="team">

                    <h1 class="title-page"><?php echo $header_title; ?></h1>
                    <section id="breadcrumb" class="border-bottom mb-4">
                        <?php include PATH_VIEW . '/layout/breadcrumb.tpl' ?>
                    </section>


                    <div class="row">
                        <?php if ($itemList) { ?>
                            <?php foreach ($itemList as $item) { ?>
                                <div class="col-md-3 col-sm-6 col-6 mb-4">
                                    <div class="card team-card h-100">
                                        <img loading="lazy" src="<?php echo PATH_SYSTEM . "public/team/" . $item->avatar; ?>" class="card-img-top" alt="<?php echo $item->name; ?>">
                                        <div class="card-body text-center">
                                            <h3 class="card-title"><?php echo $item->name; ?></h3>
                                            <h5 class="card-subtitle mb-2 text-body-secondary"><?php echo $item->office; ?></h5>
                                            <p class="card-text"><?php echo $item->description; ?></p>
                                        </div>
                                        <?php
                                        if (
                                            $item->link_whatsapp ||
                                            $item->link_youtube ||
                                            $item->link_instagram ||
                                            $item->link_facebook ||
                                            $item->link_tiktok ||
                                            $item->link_linkedin ||
                                            $item->link_twitter ||
                                            $item->link_discord
                                        ) { ?>
                                            <div class="card-footer">
                                                <ul class="nav nav-pills">
                                                    <?php if ($item->link_whatsapp) { ?>
                                                        <li><a href="https://api.whatsapp.com/send?phone=<?php echo $item->link_whatsapp; ?>" target="_blank" aria-label="WhatsApp"><i class="fab fa-whatsapp"></i></a></li>
                                                    <?php } ?>

                                                    <?php if ($item->link_youtube) { ?>
                                                        <li><a href="<?php echo $item->link_youtube; ?>" target="_blank" aria-label="Youtube"><i class="fab fa-youtube"></i></a></li>
                                                    <?php } ?>

                                                    <?php if ($item->link_instagram) { ?>
                                                        <li><a href="<?php echo $item->link_instagram; ?>" target="_blank" aria-label="Instagram"><i class="fab fa-instagram"></i></a></li>
                                                    <?php } ?>

                                                    <?php if ($item->link_facebook) { ?>
                                                        <li><a href="<?php echo $item->link_facebook; ?>" target="_blank" aria-label="Facebook"><i class="fab fa-facebook"></i></a></li>
                                                    <?php } ?>

                                                    <?php if ($item->link_tiktok) { ?>
                                                        <li><a href="<?php echo $item->link_tiktok; ?>" target="_blank" aria-label="TikTok"><i class="fab fa-tiktok"></i></a></li>
                                                    <?php } ?>

                                                    <?php if ($item->link_linkedin) { ?>
                                                        <li><a href="<?php echo $item->link_linkedin; ?>" target="_blank" aria-label="Linkedin"><i class="fab fa-linkedin"></i></a></li>
                                                    <?php } ?>

                                                    <?php if ($item->link_twitter) { ?>
                                                        <li><a href="<?php echo $item->link_twitter; ?>" target="_blank" aria-label="Twitter"><i class="fab fa-x-twitter"></i></a></li>
                                                    <?php } ?>

                                                    <?php if ($item->link_discord) { ?>
                                                        <li><a href="<?php echo $item->link_discord; ?>" target="_blank" aria-label="Discord"><i class="fab fa-discord"></i></a></li>
                                                    <?php } ?>
                                                </ul>
                                            </div>
                                        <?php } ?>

                                    </div>
                                </div>
                            <?php } ?>
                        <?php } ?>
                    </div>

                </section>
            </div>

        </div>

    </div>
</div>

<?php include PATH_VIEW . '/layout/footer.tpl'; ?>
