<?php if (statusModule('users', 'clients') == 1 && statusModule('communication', 'chat') == 1) { ?>
    <section class="mb-4 col-md-<?php echo !empty($widget) ? $widget->col : '12'; ?>">
        <?php if ($page1 != 'profile') { ?>
            <h2 class="title"><?php echo $_LANG['chat']; ?></h2>
        <?php } ?>
        <div id="chatBS">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex flex-column">
                        <div id="chat-view" class="d-flex">
                            <div id="messages">
                                <ul></ul>
                            </div>
                            <div id="users">
                                <ul></ul>
                            </div>
                            <div class="position-absolute top-0 end-0 p-3 ">
                                <button type="button" class="btn btn-dark btn-sm btn-user-open me-1" id="usertoggle" aria-label="Users Online"><i class="fas fa-user"></i> <span></span></button>
                                <button type="button" id="usertoggle" class="btn btn-dark btn-sm d-none btn-user-close d-none me-1" aria-label="Close"><i class="fas fa-angle-right"></i></button>
                            </div>
                        </div>
                        <div id="message-input" class="d-flex">
                            <textarea aria-label="<?php echo $_LANG['message']; ?>" class="form-control" maxlength="500" placeholder="<?php echo $_LANG['message']; ?>..."></textarea>
                            <button class="btn btn-primary" aria-label="<?php echo $_LANG['send']; ?>"><i class="fas fa-paper-plane"></i></button>
                        </div>
                    </div>
                    <div id="login-view" class="d-flex justify-content-center align-items-center">
                        <div class="text-center ">
                            <p class="h3 d-block mb-3 welcome"><?php echo $_LANG['welcome_chat']; ?></p>
                            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalLogin"><?php echo $_LANG['login']; ?></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php } ?>
