<?php
$config['theme_name'] = 'Default';

$config['theme_mode'] = array(
    'dark' => 'Dark',
    'light' => 'Light',
    'auto' => 'Auto (system default)',
    'custom' => 'Custom',
);

$config['positions'] = array(
    1 => $_LANG['header'],
    2 => $_LANG['contents'],
    //3 => $_LANG['sidebar_left'],
    4 => $_LANG['sidebar_right'],
    5 => $_LANG['footer']
);

$config['shortcodes'] = array(
    '[contact-form]' => '
		<h2 class="mb-3">' . $_LANG['contact_form'] . '</h2>
        <form id="contact-form" method="post" class="no-ajaxy">
            <div class="form-floating mb-3">
                <input type="text" class="form-control" name="name" id="name_contact" placeholder="' . $_LANG['name'] . '" maxlength="350" required="">
                <label for="name_contact" class="form-label">' . $_LANG['name'] . '</label>
            </div>
            <div class="form-floating mb-3">
                <input type="text" class="form-control" name="subject" id="subject_contact" placeholder="' . $_LANG['subject'] . '" maxlength="350" required="">
                <label for="subject_contact" class="form-label">' . $_LANG['subject'] . '</label>
            </div>
            <div class="form-floating mb-3">
                <input type="email" class="form-control" name="email" id="email_contact"  placeholder="' . $_LANG['email'] . '" pattern="[^@]+@[^@]+\.[a-zA-Z]{2,10}" required="" maxlength="350" >
                <label for="email_contact" class="form-label">' . $_LANG['email'] . '</label>
            </div>
            <div class="form-floating mb-3">
                <textarea class="form-control" name="message" id="message_contact" style="height: 140px" placeholder="' . $_LANG['message'] . '" required="" maxlength="500"></textarea>
                <label for="message_contact" class="form-label">' . $_LANG['message'] . '</label>
            </div>
            <span class="captcha-code-modal"></span>
			<div class="mb-3 text-center">
				<button type="submit" class="submit btn btn-primary">' . $_LANG['send'] . '</button>
                <button class="loading btn btn-primary d-none" type="button" disabled>
                    <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                    <span class="visually-hidden">' . $_LANG['loading'] . '</span>
                </button>
                <span id="res-message" class="d-block mt-3"></span>
			</div>
        </form>
    '
);
