<!DOCTYPE html>
<html lang="<?php echo $_LANG['lang_html']; ?>" data-bs-theme="<?php echo $setting->theme_mode_site; ?>">

<head itemtype="https://schema.org/WebSite">
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title><?php echo $page_title; ?></title>
    <meta name="description" content="<?php echo $page_description; ?>">

    <link rel="icon" href="<?php echo PATH_SYSTEM; ?>public/<?php echo $setting->favicon_site; ?>">

    <meta property="og:type" content="website">
    <meta property="og:title" content="<?php echo $og_title; ?>">
    <meta property="og:description" content="<?php echo $og_description; ?>">
    <meta property="og:image:width" content="<?php echo $og_image_width; ?>">
    <meta property="og:image:height" content="<?php echo $og_image_height; ?>">
    <meta property="og:image" content="<?php echo $og_image; ?>">
    <meta property="og:url" content="<?php echo $og_url; ?>">
    <link rel="canonical" href="<?php echo $canonical; ?>">

    <!-- preload -->
    <link rel="preconnect" href="https://www.googletagmanager.com">
    <link rel="preconnect" href="https://www.youtube.com">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

    <link rel="preload" as="style" href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&display=swap">
    <link rel="preload" as="style" href="<?php echo PATH_SYSTEM; ?>resources/css/bootstrap.min.css">
    <link rel="preload" as="style" href="<?php echo PATH_SYSTEM; ?>resources/css/main.css?v=<?php echo $setting->version; ?>">
    <!-- preload end -->

    <!-- css custom -->
    <?php
    if (!empty($stylesheet)) {
        foreach ($stylesheet as $style) {
            echo '<link rel="preload" as="style"  href="' . $style . '?v=' . $setting->version . '">';
            echo '<link rel="stylesheet" href="' . $style . '?v=' . $setting->version . '">';
        }
    }
    ?>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&display=swap">
    <link rel="stylesheet" href="<?php echo PATH_SYSTEM; ?>resources/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo PATH_SYSTEM; ?>resources/css/main.css?v=<?php echo $setting->version; ?>">

    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "WebSite",
            "name": "<?php echo $setting->title_site; ?>",
            "url": "<?php echo BASE_URL; ?>"
        }
    </script>
    <?php

    //bg
    $background_type = !empty($theme_global->background) ? $theme_global->background : '';
    $background_color = !empty($theme_global->background_color) && $background_type != '' ? $theme_global->background_color : 'var(--bs-dark-bg-subtle)';
    $background_image = '';

    if ($background_type === 'image') {
        $background_image = !empty($theme_global->background_image) ? "url(" . PATH_SYSTEM . "public/{$theme_global->background_image}) center center / cover no-repeat fixed" : '';
    }

    $bg_primary = !empty($theme_custom->bg_primary) ? $theme_custom->bg_primary : '##1a1d20';
    $bg_secondary = !empty($theme_custom->bg_secondary) ? $theme_custom->bg_secondary : '#2b3035';
    $bg_tertiary = !empty($theme_custom->bg_tertiary) ? $theme_custom->bg_tertiary : '#212529';

    //text
    $text_primary = !empty($theme_custom->text_primary) ? $theme_custom->text_primary : '#f8f9fa';
    $text_secondary = !empty($theme_custom->text_secondary) ? $theme_custom->text_secondary : '#adb5bd';
    $text_tertiary = !empty($theme_custom->text_tertiary) ? $theme_custom->text_tertiary : '#f8f9fa';

    ?>
    <style>
        <?php if ($background_type != '') { ?>

        /* custom */
        body {
            background: <?php echo $background_image; ?>;
            background-color: <?php echo $background_color; ?>;
        }

        .bg-body-tertiary {
            background-color: rgba(var(--bs-tertiary-bg-rgb), 0.9) !important;
        }

        .bg-body-secondary {
            background-color: rgba(var(--bs-secondary-bg-rgb), 0.9) !important;
        }

        [data-bs-theme='dark'] {
            #footer-info {
                background: rgba(19 21 23 / 0.9);
            }

            .card {
                background-color: rgba(255, 255, 255, 0.1);
            }
        }

        [data-bs-theme='light'] {
            #footer-info {
                background: rgba(222 226 230 / 0.9);
            }

            .card {
                background-color: rgba(255, 255, 255, 0.6);
            }
        }

        <?php } ?>
        /*  */
        <?php if ($setting->theme_mode_site == 'custom') { ?>
        /*  */
        <?php if ($background_type == '') { ?>

        /*  */
        body {
            background-color: <?php echo $bg_primary; ?>;
        }

        <?php } ?>

        /*  */
        .bg-body-tertiary {
            background: <?php echo $bg_secondary; ?>e6 !important;
        }

        .dropdown-menu,
        header .offcanvas {
            background: <?php echo $bg_secondary; ?> !important;
        }

        .navbar a,
        .navbar .navbar-toggler {
            color: <?php echo $text_primary; ?>;
        }

        .navbar a:hover {
            color: <?php echo $text_tertiary; ?> !important;
            background: none;
        }

        .navbar .active {
            color: <?php echo $text_secondary; ?> !important;
            background: none;
        }

        .just-now {
            color: <?php echo $text_secondary; ?> !important;
        }

        .text-muted,
        .card-subtitle,
        .datatime {
            color: <?php echo $text_primary; ?>cc !important;
        }

        .timetable table tr.active {
            background-color: <?php echo $text_primary; ?>45;
        }

        footer #footer {
            background: <?php echo $bg_secondary; ?>cc !important;
        }

        footer #footer-info {
            background: <?php echo $bg_secondary; ?>f2;
        }

        #chatBS .card {
            background: <?php echo $bg_tertiary; ?>e6;
        }

        <?php if (getContrastColor($bg_tertiary) == '#000000') { ?>
        /*  */

        #chatBS .message-body {
            background: rgba(0, 0, 0, 0.2);
        }

        #chatBS .color:before {
            color: #0020cf;
        }

        #chatBS .color_1:before {
            color: #ff5722;
        }

        #chatBS .color_2:before {
            color: #9C27B0;
        }

        #chatBS .color_3 {
            color: #ff5722;
        }

        #chatBS .color_4 {
            color: #9C27B0;
        }

        #chatBS .color_5 {
            color: #0020cf;
        }

        <?php  } ?>

        /*  */
        .page-link {
            color: <?php echo $text_primary; ?>;
            background: <?php echo $bg_secondary ?>;
        }

        .modal .modal-content {
            background: <?php echo $bg_secondary; ?>;
        }

        .pagination {
            --bs-pagination-disabled-color: <?php echo getContrastColor($text_primary); ?>;
        }

        [data-bs-theme='custom'] {
            --bs-btn-close-color: <?php echo $text_primary ?>;
            --bs-dark-bg-subtle: <?php echo $text_secondary ?>;
            --bs-form-control-bg: <?php echo $bg_tertiary; ?>;
            --bs-border-color: <?php echo $text_tertiary; ?>;
            --bs-secondary-color: <?php echo $text_secondary; ?>;
            --bs-dark-text: <?php echo $text_tertiary; ?>;
            --bs-body-bg: <?php echo $bg_tertiary; ?>cc;
            --bs-heading-color: <?php echo $text_primary; ?>;
            --bs-body-color: <?php echo $text_primary; ?>;
            --bs-emphasis-color: <?php echo $bg_tertiary; ?>;
        }

        <?php echo (getContrastColor($bg_secondary) != '#000000') ? " .btn-close {filter: var(--bs-btn-close-white-filter);}" : ''; ?>
        /*  */
        <?php } ?>
    </style>

</head>

<body itemscope itemtype="https://schema.org/WebPage">
