<?php if (statusModule('users', 'clients') == 1) {
    if (!$clientId) { ?>
        <div class="modal fade" id="modalLogin" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="modalLogin" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered ">
                <div class="modal-content">
                    <div class="modal-header text-center border-0">
                        <h5 class="modal-title fs-5 w-100"><?php echo $_LANG['login']; ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form id="userLogin" method="post" class="no-ajaxy">
                            <div class="form-floating mb-3">
                                <input type="text" class="form-control" id="username" placeholder="<?php echo $_LANG['user_email']; ?>" name="username" autocomplete="username" required="">
                                <label for="username"><?php echo $_LANG['user_email']; ?></label>
                            </div>
                            <div class="form-floating mb-3">
                                <input type="password" class="form-control" id="password" placeholder="<?php echo $_LANG['password']; ?>" name="password" autocomplete="current-password" required="">
                                <label for="password"><?php echo $_LANG['password']; ?></label>
                            </div>

                            <div class="text-end mb-3">
                                <a href="#" data-bs-toggle="modal" data-bs-target="#modalPassReset"><?php echo $_LANG['forget_password']; ?></a>
                            </div>

                            <div class="mb-4 text-center">
                                <button type="submit" class="submit btn btn-primary"><?php echo $_LANG['login']; ?></button>
                                <button class="loading btn btn-primary d-none" type="button" disabled="">
                                    <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                    <span class="visually-hidden"><?php echo $_LANG['loading']; ?></span>
                                </button>
                                <span id="res-message" class="d-block mt-3"></span>
                            </div>
                            <div class="text-center  mb-3">
                                <span><?php echo $_LANG['not_have_acc']; ?></span>
                                <a href="#" data-bs-toggle="modal" data-bs-target="#modalRegister"><?php echo $_LANG['register']; ?></a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="modalRegister" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="modalRegister" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header text-center border-0">
                        <h5 class="modal-title fs-5 w-100"><?php echo $_LANG['register']; ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form id="userRegister" method="post" class="no-ajaxy">
                            <div class="form-floating mb-3">
                                <input type="text" class="form-control" id="full_name" placeholder="<?php echo $_LANG['full_name']; ?>" name="full_name" required="" maxlength="40">
                                <label for="full_name"><?php echo $_LANG['full_name']; ?></label>
                            </div>
                            <div class="form-floating mb-3">
                                <input type="email" class="form-control" id="email" pattern="[^@]+@[^@]+\.[a-zA-Z]{2,10}" placeholder="<?php echo $_LANG['email']; ?>" name="email" required="">
                                <label for="email"><?php echo $_LANG['email']; ?></label>
                            </div>
                            <div class="form-floating mb-3">
                                <input type="text" class="form-control" id="user_name_reg" placeholder="<?php echo $_LANG['user']; ?>" name="username" pattern="[a-zA-Z0-9]+" required="" minlength="3" maxlength="30">
                                <label for="user_name_reg"><?php echo $_LANG['user']; ?></label>
                            </div>
                            <div class="form-floating mb-3">
                                <input type="password" autocomplete="new-password" class="form-control" id="password_reg" placeholder="<?php echo $_LANG['password']; ?>" name="password" required="" minlength="8">
                                <label for="password_reg"><?php echo $_LANG['password']; ?></label>
                            </div>
                            <span class="captcha-code-modal"></span>
                            <div class="mb-3 text-center">
                                <button type="submit" class="submit btn btn-primary"><?php echo $_LANG['register']; ?></button>
                                <button class="loading btn btn-primary d-none" type="button" disabled="">
                                    <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                    <span class="visually-hidden"><?php echo $_LANG['loading']; ?></span>
                                </button>
                                <span id="res-message" class="d-block mt-3"></span>
                            </div>
                            <div class="mb-4 text-center">
                                <small><?php echo $_LANG['terms_policy_accept']; ?> <a data-bs-dismiss="modal" href="<?php echo PATH_SYSTEM; ?>service-terms"><?php echo $_LANG['terms']; ?></a> e <a data-bs-dismiss="modal" href="<?php echo PATH_SYSTEM; ?>privacy-policy"><?php echo $_LANG['privacy_policy']; ?></a></small>
                            </div>
                            <div class="text-center mb-3">
                                <span><?php echo $_LANG['have_acc']; ?></span>
                                <a href="#" data-bs-toggle="modal" data-bs-target="#modalLogin"><?php echo $_LANG['log-in']; ?></a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="modalVerify" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="modalVerify" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header text-center border-0">
                        <span class="modal-title fs-5 w-100"><?php echo $_LANG['email_subject_code_active']; ?></span>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form id="codeVerify" method="post" class="no-ajaxy">
                            <input id="action_verify" type="hidden" name="action" value="">
                            <p><?php echo $_LANG['code_verify_msg']; ?></p>
                            <div class="form-floating mb-3">
                                <input type="number" class="form-control" id="code_verify" placeholder="000000" name="code_verify" required="" maxlength="32">
                                <label for="code_verify"><?php echo $_LANG['code_verify']; ?></label>
                            </div>
                            <div class="mb-3 text-center">
                                <button type="submit" class="submit btn btn-primary"><?php echo $_LANG['to_check']; ?></button>
                                <button class="loading btn btn-primary d-none" type="button" disabled="">
                                    <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                    <span class="visually-hidden"><?php echo $_LANG['loading']; ?></span>
                                </button>
                                <span id="res-message" class="d-block mt-3"></span>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="modalPassReset" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="modalPassReset" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header text-center border-0">
                        <span class="modal-title fs-5 w-100"><?php echo $_LANG['forget_password']; ?></span>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form id="userPassReset" method="post" class="no-ajaxy">
                            <p><?php echo $_LANG['forget_password_msg']; ?></p>
                            <div class="form-floating mb-3">
                                <input type="email" class="form-control" id="email-pass-reset" placeholder="" name="email-pass-reset" required="">
                                <label for="email-pass-reset"><?php echo $_LANG['email'] ?></label>
                            </div>
                            <div class="mb-3 text-center">
                                <button type="submit" class="submit btn btn-primary"><?php echo $_LANG['send']; ?></button>
                                <button class="loading btn btn-primary d-none" type="button" disabled="">
                                    <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                    <span class="visually-hidden"><?php echo $_LANG['loading']; ?></span>
                                </button>
                                <span id="res-message" class="d-block mt-3"></span>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>
<?php } ?>

<div class="modal fade" id="modalMsg" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="modalMsg" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header text-center border-0">
                <span id="title" class="modal-title fs-5 w-100"></span>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center">
                <span id="content"></span>
            </div>
        </div>
    </div>
</div>

<?php if (statusModule('communication', 'music-request') == 1) { ?>
    <div class="modal fade" id="modalMusicRequest" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="modalMusicRequest" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header text-center border-0">
                    <span class="modal-title fs-5 w-100"><?php echo $_LANG['request_your_music']; ?></span>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="musicRequest" method="post" class="no-ajaxy">
                        <div class="form-floating mb-3">
                            <input type="text" class="form-control" id="request_name" placeholder="<?php echo $_LANG['name']; ?>" name="request_name" required="" maxlength="40">
                            <label for="request_name"><?php echo $_LANG['name']; ?></label>
                        </div>

                        <div class="form-floating mb-3">
                            <input type="text" class="form-control" id="request_email" placeholder="<?php echo $_LANG['email']; ?>" name="request_email" required="" pattern="[^@]+@[^@]+\.[a-zA-Z]{2,10}">
                            <label for="request_email"><?php echo $_LANG['email']; ?></label>
                        </div>
                        <div class="form-floating mb-3">
                            <textarea class="form-control h-100" name="request_music" id="request_music" rows="4" placeholder="<?php echo $_LANG['music']; ?>" required></textarea>
                            <label for="request_music"><?php echo $_LANG['music']; ?></label>
                        </div>
                        <span class="captcha-code-modal"></span>
                        <div class="mb-3 text-center">
                            <button type="submit" class="submit btn btn-primary"><?php echo $_LANG['send']; ?></button>
                            <button class="loading btn btn-primary d-none" type="button" disabled="">
                                <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                <span class="visually-hidden"><?php echo $_LANG['loading']; ?></span>
                            </button>
                            <span id="res-message" class="d-block mt-3"></span>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
