<?php include PATH_VIEW.'/layout/header.tpl'; ?>

<script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "Event",
      "name": "<?php echo $item->title; ?>",
      "startDate": "2025-07-21T19:00-05:00",
      "endDate": "2025-07-21T23:00-05:00",
      "location": {
        "@type": "Place",
        "name": "<?php echo $item->location; ?>"
      },
      "image": [
        "<?php echo $item->thumbnail; ?>"
       ],
      "description": "<?php echo $item->description; ?>"
    }
</script>


<div id="ajaxArea">
	<div class="container bg-body-tertiary p-3">
		
		<div class="row">

			<div class="col-md-8">
				
				<section id="column1" class="mb-4">

					<section id="breadcrumb" class="border-bottom mb-4">
						<?php include PATH_VIEW.'/layout/breadcrumb.tpl' ?>
					</section>
					
					<article itemscope itemtype="https://schema.org/Event">
						
					
						<h1 itemprop="name" class="title-post"><?php echo $item->title; ?></h1>
						<p itemprop="description" class="mb-0"><?php echo $item->description; ?></p>
						
						<div class="d-flex justify-content-between  flex-sm-row flex-column mb-3">
				
							<div class="mt-3">
								<div class="">
									<i class="fas fa-clock fa-item me-2"></i><?php  if($item->date_start <= $dateTimeCurrent && $item->date_end >= $dateTimeCurrent){?>
										<span class="label"><label class="badge text-bg-success"><?php echo $_LANG['now']; ?></label></span>
									<?php }elseif($item->date_end < $dateTimeCurrent){ ?>
										<span class="label"><label class="badge text-bg-danger"><?php echo $_LANG['expired']; ?></label></span>
									<?php }elseif(FormatDate('Y-m-d', $item->date_start) == $dateCurrent){ ?>
										<span class="label"><label class="badge text-bg-primary"><?php echo $_LANG['today']; ?></label></span>
									<?php } ?><span itemprop="startDate" content="<?php echo $dateContentStart; ?>"><?php echo $dateStart; ?></span>
									>
									<span itemprop="endDate" content="<?php echo $dateContentEnd; ?>"><?php echo $dateEnd; ?></span>
								</div>

								<div class="mt-2" itemprop="location" itemscope itemtype="https://schema.org/Place">
									<i class="fas fa-location fa-item me-2"></i><span itemprop="name"><?php echo $item->location; ?></span>
      					 		</div>

							</div>

							<div class="mt-3 text-center" id="shareBS" data-url="<?php echo $og_url; ?>" data-title="<?php echo $og_title; ?>"></div>
						</div>

						<figure class="mb-3">
							<img itemprop="image" loading="lazy" src="<?php echo $og_image; ?>" class="img-fluid mx-auto d-block rounded col-12" alt="<?php echo $item->title; ?>">
							<figcaption class="mt-1 text-muted"><small><?php echo $item->title . ' ' . $_LANG['photo_reproduction']; ?></small></figcaption>
						</figure>
						<p><?php echo base64_decode($item->contents); ?></p>
					</article>

					<?php include PATH_VIEW.'/layout/comments.tpl'; ?>
				</section>
				
			</div>

			<div class="col-md-4">
				<aside>
					<section id="column2" class="row">
						<?php 
							// widgets column 2
							include PATH_VIEW.'/layout/search.tpl';
							include PATH_VIEW.'/layout/category.tpl';

							$widgetPos = 4;
							include PATH_VIEW.'/layout/widget.tpl';
						?>
					</section>
				</aside>
			</div>


		</div>
		
	</div>
</div>

<?php include PATH_VIEW.'/layout/footer.tpl'; ?>