<?php if (statusModule('publish', 'news') == 1) { ?>
    <?php if ($setting->news_auto == 1 || $setting->news_auto == 2) { ?>
        <?php $latestNews = getAllRSS($setting->news_auto_category); ?>
        <?php if ($latestNews) { ?>
            <?php $latestNews = array_slice($latestNews, 0, $setting->latest_news_l); ?>
            <section class="mb-4 col-md-<?php echo $widget->col; ?>">
                <h2 class="title"><?php echo $_LANG['latest-news']; ?></h2>
                <?php foreach ($latestNews as $news) { ?>
                    <article class="card article-card">
                        <a class="link-article" href="<?php echo PATH_SYSTEM . "news/viewAuto/" . $news->postId; ?>" aria-label="<?php echo $news->title; ?>"></a>
                        <div class="row g-0">
                            <div class="col-md-4 article-img">
                                <img loading="lazy" src="<?php echo $news->thumbnail; ?>" class="img-fluid rounded-start news" alt="<?php echo $news->title; ?>">
                            </div>
                            <div class="col-md-8">
                                <div class="card-body d-flex flex-column">
                                    <h3 class="card-title"><?php echo $news->title; ?></h3>
                                    <p class="card-text"><?php echo $news->description; ?></p>
                                    <div class="card-info mt-auto">
                                        <span class="card-text"><small class="text-muted"><?php echo elapsedTime($news->date_post); ?></small></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </article>
                <?php } ?>
            </section>
        <?php } ?>
    <?php } else { ?>
        <?php $latestNews = latestNews($setting->latest_news_l); ?>
        <?php if ($latestNews) { ?>
            <section class="mb-4 col-md-12">
                <h2 class="title"><?php echo $_LANG['latest-news']; ?></h2>
                <?php foreach ($latestNews as $news) { ?>
                    <article class="card article-card">
                        <a class="link-article" href="<?php echo PATH_SYSTEM . "news/view/" . $news->id . '-' . $news->url; ?>" aria-label="<?php echo $news->title; ?>"></a>
                        <div class="row g-0">
                            <div class="col-md-4 article-img">
                                <img loading="lazy" src="<?php echo PATH_SYSTEM . "public/news/" . $news->thumbnail; ?>" class="img-fluid rounded-start" alt="<?php echo $news->title; ?>">
                            </div>
                            <div class="col-md-8">
                                <div class="card-body d-flex flex-column">
                                    <h3 class="card-title"><?php echo $news->title; ?></h3>
                                    <p class="card-text"><?php echo $news->description; ?></p>
                                    <div class="card-info mt-auto">
                                        <span class="card-text"><small class="text-muted"><?php echo elapsedTime($news->date_post); ?></small></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </article>
                <?php } ?>
            </section>
        <?php } ?>
    <?php } ?>
<?php } ?>
