<?php if (statusModule('publish', 'videos') == 1) { ?>
    <?php $latestVideos = latestVideos($setting->latest_video_l); ?>
    <?php if ($latestVideos) { ?>
        <section class="mb-3 col-md-<?php echo $widget->col; ?>">
            <h2 class="title"><?php echo $_LANG['latest-videos']; ?></h2>
            <div class="row">
                <?php foreach ($latestVideos as $video) { ?>
                    <article class="col-md-4">
                        <div class="card post1-card text-bg-dark">
                            <a class="link-post" href="<?php echo PATH_SYSTEM . "videos/view/" . $video->id . '-' . $video->url; ?>" aria-label="<?php echo $video->title; ?>"></a>
                            <img loading="lazy" src="https://img.youtube.com/vi/<?php echo $video->video; ?>/hqdefault.jpg" class="card-img" alt="<?php echo $video->title; ?>">
                            <div class="card-img-overlay d-flex flex-column">
                                <h3 class="card-title mb-auto"><?php echo $video->title; ?></h3>
                                <p class="card-text"><small><?php echo elapsedTime($video->date_post); ?></small></p>
                            </div>
                            <span class="button"><i class="fas fa-video"></i></span>
                        </div>
                    </article>
                <?php } ?>
            </div>
        </section>
    <?php } ?>
<?php } ?>
